<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Destination>
 */
class DestinationFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => fake()->name,
            'slug' => fake()->slug,
            'country_id' => mt_rand(1, 15),
            'state_id' => mt_rand(1, 15),
            'city_id' => mt_rand(1, 15),
            'description' => fake()->text,
            'thumbnail' => null,
            'status' => fake()->boolean,
        ];
    }
}
